/*  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * 
 * Strategie generale
 *   Tente par un maximum de moyens de s'approprier le milieu
 *   
 * Capture du centre :
 *   Cree un chemin direct vers le milieu de la carte puis entoure la case centrale de tours
 *     Rush le milieu et deux fontaines des le premier tour
 *   Si un adversaire prend l'avantage, une armee de mages est envoyee pour nettoyer tout a proximite (les mages font du roaming en partant des 4 cases en diagonale du centre)
 *   Regenerer les tours du centre est la priorite sur le budget du joueur
 *   Si on ne possede pas le centre, le passage est libere pour permetre a un sorcier de prendre le controle
 *   
 * Defense
 *   Pour defendre, le programe essaye de generer un nombre de sorciers sur la base toujours supperieur au nombre de sorciers pouvant arriver
 *   Les tours a porte sont detruites
 *   On essaye de toujours garder une marge de po pour pouvoir replacer les tourelles immediatement
 *   
 * Objectifs
 *   Le programme ne cherche pas a conserver les fontaines mais envoit tout de meme un sorcier sur les deux plus proches dans le cas ou personne ne tente de s en emparer en debut de partie
 *   
 * Fin du jeu
 *   A la fin du jeu (75 tours) une armee de sorciers est envoye pour gener les rush finaux
 *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

#include <iostream>
#include <algorithm>

#include "prologin.hh"

///
// Fonction appelée au début de la partie
//


struct focus {
  position pos;
  position target;
  int number;
};

struct roam {
  focus way;
  position base;
};

std::vector<focus> taupes;
std::vector<position> raliment;
std::vector<focus> garnisons;
std::vector<roam> roaming;

std::vector<position> tourelles_artefact_1;
std::vector<position> tourelles_artefact_2;
std::vector<position> tourelles_base_1;
std::vector<position> tourelles_base_2;

bool clamerde(false);

int dist(position a, position b) {
  return std::abs(a.x-b.x)+std::abs(a.y-b.y);
}

bool arrived(focus a) {
  return ((a.pos.x == a.target.x) && (a.pos.y == a.target.y));
}

int nb_mechants(position pos) {
  int r(0);
  for(unsigned int i=0 ; i<adversaires().size() ; i++) {
    r += nb_sorciers(pos, adversaires()[i]);
  }
  return r;
}

std::vector<position> chemin_accessible(position a, position b) {
  std::vector<position> r;
  std::vector<position> def = chemin(a, b);
  
  for(unsigned int i=0 ; (i<def.size()) && (info_case(def[i]) != CASE_TOURELLE) ; i++ ) {
    r.push_back(def[i]);
  }
  return r;
}

focus follow(focus a) {
  if( arrived(a) )
    return a;
  
  int longeur = std::min(PORTEE_SORCIER, dist(a.pos, a.target));
  position next = chemin_accessible(a.pos, a.target)[longeur-1];
  int nbre = std::min(a.number, nb_sorciers(a.pos, moi()));
  
  deplacer(a.pos, next, nbre);
  //std::cout << "Deplacement : " << deplacer(a.pos, next, nbre) << " ([" << a.pos.x << "," << a.pos.y << "][" << next.x << "," << next.y << "])" << std::endl;
  
  a.pos = next;
  return a;
}

position path(int i) {
  // Genere une croix
  int d = 0;
  position pointe = base_joueur(moi());
  position ecart = {x:0 , y:0};
  
  while( d < i ) {
    ecart.x += 1 + (d%2);
    ecart.y += 1 + ((d+1)%2);
    
    pointe.x = std::abs( base_joueur(moi()).x - ecart.x );
    pointe.y = std::abs( base_joueur(moi()).y - ecart.y );
    
    d++;
  }
  
  return pointe;
}

void focus_sorcier(position from) {
  for(int i=from.x-4 ; i<=from.x+4 ; i++) {		// Destruction sorciers (worth it)
    for(int j=from.y-4 ; j<=from.y+4 ; j++) {
      if(( nb_mechants({x:i, y:j}) < nb_sorciers(from, moi()) ) && ( nb_mechants({x:i, y:j}) > 0 )) {
	int n = nb_mechants({x:i, y:j})+1;
	roaming.push_back({
	  way: {
	    pos: from,
	    target: {x: i, y:j},
	    number: n
	  },
	  base: from
	});
      }
    }  
  }
}
  
void focus_tour(position from) {
  for(int i=from.x-5 ; i<=from.x+5 ; i++) {		// Destruction tours
    for(int j=from.y-5 ; j<=from.y+5 ; j++) {
      if(( joueur_case({x: i, y: j}) != moi() ) && ( info_case({x:i, y:j}) == CASE_TOURELLE )) {
	std::vector<position> chem = chemin(from, {x: i, y: j});
	if( chem.size() > 0 && chem.size() < 5 ) {
	  int n = 51;
	  roaming.push_back({
	    way: {
	      pos: from,
	      target: chem[chem.size()-2],
	      number: n * (nb_sorciers(from, moi()) >= n)
	    },
	    base: from
	  });
	}
      }
    }  
  }
}

bool take_control(std::vector<position> list) {
  bool owned = false;
  for(unsigned int i=0 ; i<list.size() ; i++) {
      std::cout << "Construcion en [" << list[i].x << "," << list[i].y << "] : Non" << std::endl ;
    if(info_case(list[i]) == CASE_SIMPLE)
    if( constructible(list[i], moi() ) ) {
      std::cout << "Construcion en [" << list[i].x << "," << list[i].y << "] : " ;
      std::cout << construire( list[i], 3 ) << std::endl;
    }
    owned = ( owned || ( (info_case(list[i]) == CASE_TOURELLE) && (joueur_case(list[i]) == moi()) ) );
  }
  return owned;
}

void give_up(std::vector<position> list) {
  for(unsigned int i=0 ; i<list.size() ; i++) { 
    supprimer( list[i] );
  }
}

void partie_debut()
{  
  tourelles_artefact_1.push_back({x:14,y:15});
  tourelles_artefact_1.push_back({x:16,y:15});
  tourelles_artefact_1.push_back({x:15,y:14});
  tourelles_artefact_1.push_back({x:15,y:16});
  
  tourelles_artefact_2.push_back({x:13,y:15});
  tourelles_artefact_2.push_back({x:17,y:15});
  tourelles_artefact_2.push_back({x:15,y:13});
  tourelles_artefact_2.push_back({x:15,y:17});
  
  tourelles_base_1.push_back({
    x: std::abs(base_joueur(moi()).x-2),
    y: std::abs(base_joueur(moi()).y-2)
  });
  
  tourelles_base_2.push_back({
    x: std::abs(base_joueur(moi()).x-1),
    y: std::abs(base_joueur(moi()).y)
  });
  tourelles_base_2.push_back({
    x: std::abs(base_joueur(moi()).x),
    y: std::abs(base_joueur(moi()).y-1)
  });
  
  
  raliment.push_back({
    x : std::abs(base_joueur(moi()).x-16),
    y : std::abs(base_joueur(moi()).y-16)
  });
  raliment.push_back({
    x : std::abs(base_joueur(moi()).x-14),
    y : std::abs(base_joueur(moi()).y-14)
  });
  raliment.push_back({
    x : std::abs(base_joueur(moi()).x-14),
    y : std::abs(base_joueur(moi()).y-16)
  });
  raliment.push_back({
    x : std::abs(base_joueur(moi()).x-16),
    y : std::abs(base_joueur(moi()).y-14)
  });
}

///
// Fonction appelée pendant la phase de construction
//
void phase_construction()
{  
  /* Envoit de taupes au debut */
  if( tour_actuel() == 0 ) {
    std::cout << "Creation : " << creer(10) << std::endl;
    
    taupes.push_back({
      pos: base_joueur(moi()),
      target: {x: base_joueur(moi()).x, y:15},
      number: 1
    });
    taupes.push_back({
      pos: base_joueur(moi()),
      target: {x: 15, y:base_joueur(moi()).y},
      number: 1
    });
    taupes.push_back({
      pos: base_joueur(moi()),
      target: {x: 15, y:15},
      number: 8
    });
  }
  
  // Evaluation du danger
  
  int danger = 0;
  position coin ({
    x: std::abs(base_joueur(moi()).x-4),
    y: std::abs(base_joueur(moi()).y-4)
  });
  for(unsigned int n=0 ; n < adversaires().size() ; n++) {
    int cum = 0;
    for( int i=std::min(coin.x, base_joueur(moi()).x) ; i<=std::max(coin.x, base_joueur(moi()).x) ; i++ ) {
      for( int j=std::min(coin.y, base_joueur(moi()).y) ; j<=std::max(coin.y, base_joueur(moi()).y) ; j++ ) {
	cum += nb_sorciers({x: i, y:j}, adversaires()[n]);
      }
    }
  position coin ({
    x: std::abs(base_joueur(moi()).x-5),
    y: std::abs(base_joueur(moi()).y-5)
  });
    for( int i=std::min(coin.x, base_joueur(moi()).x) ; i<=std::max(coin.x, base_joueur(moi()).x) ; i++ ) {
      for( int j=std::min(coin.y, base_joueur(moi()).y) ; j<=std::max(coin.y, base_joueur(moi()).y) ; j++ ) {
	if( (info_case({x: i, y:j}) == CASE_TOURELLE) && (joueur_case({x: i, y:j}) != moi()) )
	  cum += 61;
      }
    }
    danger = std::max(cum, danger);
  }
  
  if( danger > 0 ) {
    creer( danger - nb_sorciers(base_joueur(moi()), moi()) + 1 );
    focus_tour(base_joueur(moi()));
  } 
  
  // Rush le mid
  
  bool mid_editable = false;
  
  if( joueur_case({x: 15, y:15}) == moi() )
    mid_editable = mid_editable || take_control(tourelles_artefact_1);
  else {
    give_up(tourelles_artefact_1);
    for(unsigned int i=0 ; i<raliment.size() ; i++) {
      taupes.push_back({
	pos: raliment[i],
	target: {x:15,y:15},
	number: 1
      });
    }
  }
    
  mid_editable = mid_editable || take_control(tourelles_artefact_2);
  
  if( !mid_editable ) {
    // Build path
    int n = 9;
    while( !constructible(path(n), moi()) && n > 1 ) {
      n--;
    }
    std::cout << "Construire : " << construire( path(n), PORTEE_TOURELLE ) << std::endl;
    std::cout << "Supprimer : " << supprimer(path(n-3)) << std::endl;
  }
  else {
    for( int i=0 ; i<=10 ; i++) {
      supprimer(path(i));
    }
  }
  
  take_control(tourelles_base_1);
  take_control(tourelles_artefact_2);
  
  if( ( magie(moi()) > danger+600 ) && (( joueur_case({x: 15, y:15}) != moi() ) || tour_actuel() > 75 ) ){
    creer(std::max(0, (magie(moi())-danger-200 )/2));
    std::cout << tour_actuel() << " : " << int(magie(moi())/2) << " Mages" << std::endl;
    
    for(unsigned int i=0 ; i<raliment.size() ; i++) {
      garnisons.push_back({
	pos: base_joueur(moi()),
	target: raliment[i],
	number: int( (nb_sorciers(base_joueur(moi()), moi())-danger) / raliment.size() )
      });
    }
  }
}

///
// Fonction appelée pendant la phase de déplacement
//
void phase_deplacement()
{
  for(unsigned int i=0 ; i<raliment.size() ; i++) {
    position a = raliment[i];
    position b = raliment[(i+1)%raliment.size()];
    garnisons.push_back({
      pos: a,
      target: b,
      number: std::max(nb_sorciers(a, moi()) - nb_sorciers(b, moi()), 0) / 2
    });
  }
    
  for(unsigned int i=0 ; i<raliment.size() ; i++) {
    focus_tour(raliment[i]);
    focus_sorcier(raliment[i]);
  }
  
  for(unsigned int i=0 ; i<taupes.size() ; i++) {
    taupes[i] = follow(taupes[i]);
  }
  for(unsigned int i=0 ; i<garnisons.size() ; i++) {
    garnisons[i] = follow(garnisons[i]);
  }
  for(unsigned int i=0 ; i<roaming.size() ; i++) {
    roaming[i].way = follow(roaming[i].way);
    if( ( roaming[i].way.pos.x == roaming[i].way.target.x ) && ( roaming[i].way.pos.y == roaming[i].way.target.y ) ) {
      roaming[i].way.target = roaming[i].base;
    } 
  }  
}

///
// Fonction appelée pendant la phase de tirs des tourelles
//
void phase_tirs()
{
  std::vector<tourelle> tourelles(tourelles_joueur(moi()));
  for( unsigned int t=0 ; t<tourelles.size() ; t++ ) {
    tourelle tour = tourelles[t];
    for( int d=1 ; d<=tour.portee ; d++ ) {
      for( int a=tour.pos.x-d ; a<=tour.pos.x+d ; a++) {
	for( int b=tour.pos.y-d ; b<=tour.pos.y+d ; b++) {
	  if( dist(tour.pos, {x:a, y:b}) == d ) {
	    tirer( std::min(nb_mechants({x:a, y:b}), tour.attaque), tour.pos, {x:a, y:b} );
	  }
	}
      }
    }
  }
}

///
// Fonction appelée pendant la phase de siège des tourelles
//
void phase_siege()
{
  for( unsigned int j=0 ; j<adversaires().size() ; j++ ) {
    std::vector<tourelle> tourelles(tourelles_joueur(adversaires()[j]));
    for( unsigned int t=0 ; t<tourelles.size() ; t++ ) {
      for( int a=tourelles[t].pos.x-1 ; a<=tourelles[t].pos.x+1 ; a++) {
	for( int b=tourelles[t].pos.y-1 ; b<=tourelles[t].pos.y+1 ; b++) {
	  if( dist({x:a,y:b}, tourelles[t].pos) <= 1) {
	    assieger( {x:a,y:b}, tourelles[t].pos, std::min( nb_sorciers({x:a,y:b}, moi()), tourelles[t].vie ) );
	  }
	}
      }
    }
  }
}

///
// Fonction appelée à la fin de la partie
//
void partie_fin()
{
  // fonction a completer
}

