///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

#include <iostream>
#include <algorithm>

#include "prologin.hh"

///
// Fonction appelée au début de la partie
//


struct focus {
  position pos;
  position target;
  int number;
};

struct roam {
  focus way;
  position base;
};

std::vector<focus> taupes;
std::vector<position> raliment;
std::vector<focus> garnisons;
std::vector<roam> roaming;

int dist(position a, position b) {
  return std::abs(a.x-b.x)+std::abs(a.y-b.y);
}

bool arrived(focus a) {
  return ((a.pos.x == a.target.x) && (a.pos.y == a.target.y));
}

int nb_mechants(position pos) {
  int r(0);
  for(unsigned int i=0 ; i<adversaires().size() ; i++) {
    r += nb_sorciers(pos, adversaires()[i]);
  }
  return r;
}

focus follow(focus a) {
  if( arrived(a) )
    return a;
  
  int longeur = std::min(PORTEE_SORCIER, dist(a.pos, a.target));
  position next = chemin(a.pos, a.target)[longeur-1];
  int nbre = std::min(a.number, nb_sorciers(a.pos, moi()));
  
  std::cout << "Deplacement : " << deplacer(a.pos, next, nbre) << " ([" << a.pos.x << "," << a.pos.y << "][" << next.x << "," << next.y << "])" << std::endl;
  
  a.pos = next;
  return a;
}

position path(int i) {							// A OPTIMISER
  // Genere une croix
  int d = 0;
  position pointe = base_joueur(moi());
  position ecart = {x:0 , y:0};
  
  while( d < i ) {
    ecart.x += 1 + (d%2);
    ecart.y += 1 + ((d+1)%2);
    
    pointe.x = std::abs( base_joueur(moi()).x - ecart.x );
    pointe.y = std::abs( base_joueur(moi()).y - ecart.y );
    
    d++;
  }
  
  return pointe;
}

bool own_mid() {
  bool owned = false;
  for(int i=14 ; i<=16 ; i++) {
    for(int j=14 ; j<=16 ; j++) {
      position pointe = {x:i, y:j};
      if( constructible( pointe, moi() ) ) {
	construire( pointe, 3 );
      }
      owned = ( owned || ( (info_case(pointe) == CASE_TOURELLE) && (joueur_case(pointe) == moi()) ) );
    }
  }
  return owned;
}

void fill_towers(position centre, int rayon) {
  for(int r=0 ; (r<rayon) && (magie(moi()) > 20) ; r++) {
    /*for(int i=centre.x-r ; (i <= centre.x+r) && (magie(moi()) > 20) ; i++) {
      for(int j=centre.y-r ; (j <= centre.y+r) && (magie(moi()) > 20) ; j++) {
	position pointe;
	  pointe.x = i;
	  pointe.y = j;
	if( constructible( pointe, moi() ) ) {
	  construire( pointe, 3 );
	}
      }
    }*/
    for(int i=centre.x-r+1 ; (i <= centre.x+r) && (magie(moi()) > 20) ; i+=2) {
      for(int j=centre.y-r ; (j <= centre.y+r) && (magie(moi()) > 20) ; j+=2) {
	position pointe;
	  pointe.x = i;
	  pointe.y = j;
	if( constructible( pointe, moi() ) ) {
	  construire( pointe, 3 );
	}
      }
    }
    for(int i=centre.x-r ; (i <= centre.x+r) && (magie(moi()) > 20) ; i++) {
      for(int j=centre.y-r ; (j <= centre.y+r) && (magie(moi()) > 20) ; j++) {
	position pointe;
	  pointe.x = i;
	  pointe.y = j;
	if( constructible( pointe, moi() ) ) {
	  construire( pointe, 3 );
	}
      }
    }
  }
}

void focus(position from) {
  for(int i=from.x-4 ; i<=from.x+4 ; i++) {		// Destruction sorciers (worth it)
    for(int j=from.y-4 ; j<=from.y+4 ; j++) {
      if(( nb_mechants({x:i, y:j}) < nb_sorciers(from, moi()) ) && ( nb_mechants({x:i, y:j}) > 0 )) {
	int n = nb_mechants({x:i, y:j})+1;
	roaming.push_back({
	  way: {
	    pos: from,
	    target: {x: i, y:j},
	    number: n
	  },
	  base: from
	});
      }
    }  
  }
  
  for(int i=from.x-5 ; i<=from.x+5 ; i++) {		// Destruction tours
    for(int j=from.y-5 ; j<=from.y+5 ; j++) {
      if(( joueur_case({x: i, y: j}) != moi() ) && ( info_case({x:i, y:j}) == CASE_TOURELLE )) {
	std::vector<position> chem = chemin(from, {x: i, y: j});
	if( chem.size() > 0 && chem.size() < 5 ) {
	  int n = nb_mechants({x:i, y:j}) + 41;
	  roaming.push_back({
	    way: {
	      pos: from,
	      target: chem[chem.size()-2],
	      number: n * (nb_sorciers(from, moi()) >= n)
	    },
	    base: from
	  });
	}
      }
    }  
  }
}

void partie_debut()
{
  raliment.push_back({
    x : std::abs(base_joueur(moi()).x-16),
    y : std::abs(base_joueur(moi()).y-13)
  });
  raliment.push_back({
    x : std::abs(base_joueur(moi()).x-13),
    y : std::abs(base_joueur(moi()).y-16)
  });
}

///
// Fonction appelée pendant la phase de construction
//
void phase_construction()
{
  /* Envoit de taupes au debut */
  if( tour_actuel() == 0 ) {
    std::cout << "Creation : " << creer(10) << std::endl;
    
    taupes.push_back({
      pos: base_joueur(moi()),
      target: {x: base_joueur(moi()).x, y:15},
      number: 1
    });
    taupes.push_back({
      pos: base_joueur(moi()),
      target: {x: 15, y:base_joueur(moi()).y},
      number: 1
    });
    taupes.push_back({
      pos: base_joueur(moi()),
      target: {x: 15, y:15},
      number: 8
    });
  }
  
  if( ! own_mid() ) {
    // Build path
    int n = 9;
    while( !constructible(path(n), moi()) && n > 1 ) {
      n--;
    }
    construire( path(n), PORTEE_TOURELLE );
    std::cout << "Supprimer : " << supprimer(path(n-1)) << std::endl;
  }
  else {
    for( int i=0 ; i<=10 ; i++) {
      supprimer(path(i));
    }
    construire({
      x: std::abs(base_joueur(moi()).x-1),
      y: std::abs(base_joueur(moi()).y-1)
    }, 3);
  }
  
  creer(std::max(0, (magie(moi())-160 )/2));
  std::cout << tour_actuel() << " : " << int(magie(moi())/2) << " Mages" << std::endl;
  
  for(unsigned int i=0 ; i<raliment.size() ; i++) {
    garnisons.push_back({
      pos: base_joueur(moi()),
      target: raliment[i],
      number: int( nb_sorciers(base_joueur(moi()), moi()) / raliment.size() )
    });
  }
}

///
// Fonction appelée pendant la phase de déplacement
//
void phase_deplacement()
{
  for(unsigned int i=0 ; i<raliment.size() ; i++) {
    position a = raliment[i];
    position b = raliment[(i+1)%raliment.size()];
    garnisons.push_back({
      pos: a,
      target: b,
      number: std::max(nb_sorciers(a, moi()) - nb_sorciers(b, moi()), 0) / 2
    });
  }
    
  for(unsigned int i=0 ; i<raliment.size() ; i++) {
    focus(raliment[i]);
  }
  
  for(unsigned int i=0 ; i<taupes.size() ; i++) {
    taupes[i] = follow(taupes[i]);
  }
  for(unsigned int i=0 ; i<garnisons.size() ; i++) {
    garnisons[i] = follow(garnisons[i]);
  }
  for(unsigned int i=0 ; i<roaming.size() ; i++) {
    roaming[i].way = follow(roaming[i].way);
    if( ( roaming[i].way.pos.x == roaming[i].way.target.x ) && ( roaming[i].way.pos.y == roaming[i].way.target.y ) ) {
      roaming[i].way.target = roaming[i].base;
    } 
  }
}

///
// Fonction appelée pendant la phase de tirs des tourelles
//
void phase_tirs()
{
  std::vector<tourelle> tourelles(tourelles_joueur(moi()));
  for( unsigned int t=0 ; t<tourelles.size() ; t++ ) {
    tourelle tour = tourelles[t];
    for( int d=1 ; d<=tour.portee ; d++ ) {
      for( int a=tour.pos.x-d ; a<=tour.pos.x+d ; a++) {
	for( int b=tour.pos.y-d ; b<=tour.pos.y+d ; b++) {
	  if( dist(tour.pos, {x:a, y:b}) == d ) {
	    tirer( std::min(nb_mechants({x:a, y:b}), tour.attaque), tour.pos, {x:a, y:b} );
	  }
	}
      }
    }
  }
}

///
// Fonction appelée pendant la phase de siège des tourelles
//
void phase_siege()
{
  for( unsigned int j=0 ; j<adversaires().size() ; j++ ) {
    std::vector<tourelle> tourelles(tourelles_joueur(adversaires()[j]));
    for( unsigned int t=0 ; t<tourelles.size() ; t++ ) {
      for( int a=tourelles[t].pos.x-1 ; a<=tourelles[t].pos.x+1 ; a++) {
	for( int b=tourelles[t].pos.y-1 ; b<=tourelles[t].pos.y+1 ; b++) {
	  if( dist({x:a,y:b}, tourelles[t].pos) <= 1) {
	    assieger( {x:a,y:b}, tourelles[t].pos, std::min( nb_sorciers({x:a,y:b}, moi()), tourelles[t].vie ) );
	  }
	}
      }
    }
  }
}

///
// Fonction appelée à la fin de la partie
//
void partie_fin()
{
  // fonction a completer
}

