/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.bottombar;

import com.mojang.authlib.UserAuthentication;
import com.mojang.launcher.events.RefreshedProfilesListener;
import com.mojang.launcher.events.RefreshedVersionsListener;
import com.mojang.launcher.profile.Profile;
import com.mojang.launcher.profile.ProfileManager;
import com.mojang.launcher.updater.VersionManager;
import com.mojang.launcher.updater.VersionSyncInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;

public class PlayerInfoPanel
extends JPanel
implements RefreshedProfilesListener,
RefreshedVersionsListener {
    private final Launcher minecraftLauncher;
    private final JLabel welcomeText = new JLabel("", 0);
    private final JLabel versionText = new JLabel("", 0);
    private final JButton logOutButton = new JButton("Log Out");

    public PlayerInfoPanel(final Launcher minecraftLauncher) {
        this.minecraftLauncher = minecraftLauncher;
        minecraftLauncher.getLauncher().getProfileManager().addRefreshedProfilesListener(this);
        this.checkState();
        this.createInterface();
        this.logOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                minecraftLauncher.getLauncher().getProfileManager().getSelectedProfile().setPlayerUUID(null);
                minecraftLauncher.getLauncher().getProfileManager().trimAuthDatabase();
                minecraftLauncher.getUserInterface().showLoginPrompt();
            }
        });
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        this.add((Component)this.welcomeText, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.gridwidth = 2;
        this.add((Component)this.versionText, constraints);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        ++constraints.gridy;
        constraints.weightx = 0.5;
        constraints.fill = 0;
        this.add((Component)this.logOutButton, constraints);
        constraints.weightx = 0.0;
        ++constraints.gridy;
    }

    @Override
    public void onProfilesRefreshed(ProfileManager manager) {
        this.checkState();
    }

    public void checkState() {
        VersionSyncInfo requestedVersion;
        VersionSyncInfo version;
        Profile profile = this.minecraftLauncher.getLauncher().getProfileManager().getProfiles().isEmpty() ? null : this.minecraftLauncher.getLauncher().getProfileManager().getSelectedProfile();
        UserAuthentication auth = profile == null ? null : this.minecraftLauncher.getLauncher().getProfileManager().getAuthDatabase().getByUUID(profile.getPlayerUUID());
        List<VersionSyncInfo> versions = profile == null ? null : this.minecraftLauncher.getLauncher().getVersionManager().getVersions(profile.getVersionFilter());
        VersionSyncInfo versionSyncInfo = version = profile == null || versions.isEmpty() ? null : versions.get(0);
        if (profile != null && profile.getLastVersionId() != null && (requestedVersion = this.minecraftLauncher.getLauncher().getVersionManager().getVersionSyncInfo(profile.getLastVersionId())) != null && requestedVersion.getLatestVersion() != null) {
            version = requestedVersion;
        }
        if (auth == null || !auth.isLoggedIn()) {
            this.welcomeText.setText("Welcome, guest! Please log in.");
            this.logOutButton.setEnabled(false);
        } else if (auth.getSelectedProfile() == null) {
            this.welcomeText.setText("<html>Welcome, player!</html>");
            this.logOutButton.setEnabled(true);
        } else {
            this.welcomeText.setText("<html>Welcome, <b>" + auth.getSelectedProfile().getName() + "</b></html>");
            this.logOutButton.setEnabled(true);
        }
        if (version == null) {
            this.versionText.setText("Loading versions...");
        } else if (version.isUpToDate()) {
            this.versionText.setText("Ready to play Minecraft " + version.getLatestVersion().getId());
        } else if (version.isInstalled()) {
            this.versionText.setText("Ready to update & play Minecraft " + version.getLatestVersion().getId());
        } else if (version.isOnRemote()) {
            this.versionText.setText("Ready to download & play Minecraft " + version.getLatestVersion().getId());
        }
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlayerInfoPanel.this.checkState();
            }
        });
    }

    public Launcher getMinecraftLauncher() {
        return this.minecraftLauncher;
    }
}

