/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.game.runner;

import com.google.common.base.Objects;
import com.mojang.launcher.Launcher;
import com.mojang.launcher.game.runner.GameRunner;
import com.mojang.launcher.profile.LauncherVisibilityRule;
import com.mojang.launcher.profile.Profile;
import com.mojang.launcher.updater.VersionSyncInfo;
import com.mojang.launcher.updater.download.DownloadJob;
import com.mojang.launcher.updater.download.DownloadListener;
import com.mojang.launcher.versions.CompleteVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGameRunner
implements GameRunner,
DownloadListener {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Object lock = new Object();
    private final List<DownloadJob> jobs = new ArrayList<DownloadJob>();
    protected CompleteVersion version;
    protected LauncherVisibilityRule visibilityRule;
    private boolean isWorking;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWorking(boolean working) {
        Object object = this.lock;
        synchronized (object) {
            this.isWorking = working;
            this.getLauncher().getUserInterface().updatePlayState();
        }
    }

    protected abstract Launcher getLauncher();

    @Override
    public boolean isWorking() {
        return this.isWorking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playGame(Profile profile) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isWorking) {
                LOGGER.warn("Tried to play game but game is already starting!");
                return;
            }
            this.setWorking(true);
        }
        LOGGER.info("Getting syncinfo for selected version");
        String lastVersionId = profile.getLastVersionId();
        VersionSyncInfo syncInfo = null;
        this.visibilityRule = Objects.firstNonNull(profile.getLauncherVisibilityOnGameClose(), Profile.DEFAULT_LAUNCHER_VISIBILITY);
        if (lastVersionId != null) {
            syncInfo = this.getLauncher().getVersionManager().getVersionSyncInfo(lastVersionId);
        }
        if (syncInfo == null || syncInfo.getLatestVersion() == null) {
            syncInfo = this.getLauncher().getVersionManager().getVersions(profile.getVersionFilter()).get(0);
        }
        if (syncInfo == null) {
            LOGGER.warn("Tried to launch a version without a version being selected...");
            this.setWorking(false);
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            LOGGER.info("Queueing library & version downloads");
            try {
                this.version = this.getLauncher().getVersionManager().getLatestCompleteVersion(syncInfo);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't get complete version info for " + syncInfo.getLatestVersion(), (Throwable)e);
                this.setWorking(false);
                return;
            }
            if (syncInfo.getRemoteVersion() != null && syncInfo.getLatestSource() != VersionSyncInfo.VersionSource.REMOTE && !this.version.isSynced()) {
                try {
                    syncInfo = this.getLauncher().getVersionManager().syncVersion(syncInfo);
                    this.version = this.getLauncher().getVersionManager().getLatestCompleteVersion(syncInfo);
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't sync local and remote versions", (Throwable)e);
                }
                this.version.setSynced(true);
            }
            if (!this.version.appliesToCurrentEnvironment()) {
                String reason = this.version.getIncompatibilityReason();
                if (reason == null) {
                    reason = "This version is incompatible with your computer. Please try another one by going into Edit Profile and selecting one through the dropdown. Sorry!";
                }
                LOGGER.error("Version " + this.version.getId() + " is incompatible with current environment: " + reason);
                this.getLauncher().getUserInterface().gameLaunchFailure(reason);
                this.setWorking(false);
                return;
            }
            if (this.version.getMinimumLauncherVersion() > 14) {
                LOGGER.error("An update to your launcher is available and is required to play " + this.version.getId() + ". Please restart your launcher.");
                this.setWorking(false);
                return;
            }
            if (!syncInfo.isUpToDate()) {
                try {
                    this.getLauncher().getVersionManager().installVersion(this.version);
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save version info to install " + syncInfo.getLatestVersion(), (Throwable)e);
                    this.setWorking(false);
                    return;
                }
            }
            this.downloadRequiredFiles(syncInfo);
        }
    }

    protected void downloadRequiredFiles(VersionSyncInfo syncInfo) {
        try {
            DownloadJob librariesJob = new DownloadJob("Version & Libraries", false, this);
            this.addJob(librariesJob);
            this.getLauncher().getVersionManager().downloadVersion(syncInfo, librariesJob);
            librariesJob.startDownloading(this.getLauncher().getDownloaderExecutorService());
            DownloadJob resourceJob = new DownloadJob("Resources", true, this);
            this.addJob(resourceJob);
            this.getLauncher().getVersionManager().downloadResources(resourceJob, this.version);
            resourceJob.startDownloading(this.getLauncher().getDownloaderExecutorService());
        }
        catch (IOException e) {
            LOGGER.error("Couldn't get version info for " + syncInfo.getLatestVersion(), (Throwable)e);
            this.setWorking(false);
            return;
        }
    }

    protected void updateProgressBar() {
        this.getLauncher().getUserInterface().setDownloadProgress(this.hasRemainingJobs(), (int)(this.getProgress() * 100.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getProgress() {
        Object object = this.lock;
        synchronized (object) {
            float max = 0.0f;
            float result = 0.0f;
            for (DownloadJob job : this.jobs) {
                float progress = job.getProgress();
                if (!(progress >= 0.0f)) continue;
                result += progress;
                max += 1.0f;
            }
            return result / max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRemainingJobs() {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadJob job : this.jobs) {
                if (job.isComplete()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJob(DownloadJob job) {
        Object object = this.lock;
        synchronized (object) {
            this.jobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadJobFinished(DownloadJob job) {
        this.updateProgressBar();
        Object object = this.lock;
        synchronized (object) {
            if (job.getFailures() > 0) {
                LOGGER.error("Job '" + job.getName() + "' finished with " + job.getFailures() + " failure(s)! (took " + job.getStopWatch().toString() + ")");
                this.setWorking(false);
            } else {
                LOGGER.info("Job '" + job.getName() + "' finished successfully (took " + job.getStopWatch().toString() + ")");
                if (this.isWorking() && !this.hasRemainingJobs()) {
                    try {
                        this.launchGame();
                    }
                    catch (Throwable ex) {
                        LOGGER.fatal("Fatal error launching game. Report this to http://bugs.mojang.com please!", ex);
                    }
                }
            }
        }
    }

    protected abstract void launchGame() throws IOException;

    @Override
    public void onDownloadJobProgressChanged(DownloadJob job) {
        this.updateProgressBar();
    }
}

