/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.profile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.launcher.Launcher;
import com.mojang.launcher.authentication.AuthenticationDatabase;
import com.mojang.launcher.events.RefreshedProfilesListener;
import com.mojang.launcher.profile.Profile;
import com.mojang.launcher.updater.DateTypeAdapter;
import com.mojang.launcher.updater.FileTypeAdapter;
import com.mojang.launcher.updater.LowerCaseEnumTypeAdapterFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class ProfileManager {
    public static final String DEFAULT_PROFILE_NAME = "(Default)";
    private final Launcher launcher;
    private final JsonParser parser = new JsonParser();
    private final Gson gson;
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final File profileFile;
    private final List<RefreshedProfilesListener> refreshedProfilesListeners = Collections.synchronizedList(new ArrayList());
    private String selectedProfile;
    private AuthenticationDatabase authDatabase;

    public ProfileManager(Launcher launcher) {
        this.launcher = launcher;
        this.profileFile = new File(launcher.getWorkingDirectory(), "launcher_profiles.json");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)AuthenticationDatabase.class), new AuthenticationDatabase.Serializer(launcher));
        builder.registerTypeAdapter((Type)((Object)RawProfileList.class), new RawProfileList.Serializer(launcher));
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.authDatabase = new AuthenticationDatabase(new YggdrasilAuthenticationService(launcher.getProxy(), launcher.getClientToken().toString()));
    }

    public void saveProfiles() throws IOException {
        RawProfileList rawProfileList = new RawProfileList(this.profiles, this.getSelectedProfile().getName(), this.launcher.getClientToken(), this.authDatabase);
        FileUtils.writeStringToFile(this.profileFile, this.gson.toJson(rawProfileList));
    }

    public boolean loadProfiles() throws IOException {
        this.profiles.clear();
        this.selectedProfile = null;
        if (this.profileFile.isFile()) {
            JsonObject object = this.parser.parse(FileUtils.readFileToString(this.profileFile)).getAsJsonObject();
            if (object.has("clientToken")) {
                this.launcher.setClientToken(this.gson.fromJson(object.get("clientToken"), UUID.class));
            }
            RawProfileList rawProfileList = this.gson.fromJson((JsonElement)object, RawProfileList.class);
            this.profiles.putAll(rawProfileList.profiles);
            this.selectedProfile = rawProfileList.selectedProfile;
            this.authDatabase = rawProfileList.authenticationDatabase;
            this.fireRefreshEvent();
            return true;
        }
        this.fireRefreshEvent();
        return false;
    }

    public void fireRefreshEvent() {
        for (RefreshedProfilesListener listener : Lists.newArrayList(this.refreshedProfilesListeners)) {
            listener.onProfilesRefreshed(this);
        }
    }

    public Profile getSelectedProfile() {
        if (this.selectedProfile == null || !this.profiles.containsKey(this.selectedProfile)) {
            if (this.profiles.get(DEFAULT_PROFILE_NAME) != null) {
                this.selectedProfile = DEFAULT_PROFILE_NAME;
            } else if (this.profiles.size() > 0) {
                this.selectedProfile = this.profiles.values().iterator().next().getName();
            } else {
                this.selectedProfile = DEFAULT_PROFILE_NAME;
                this.profiles.put(DEFAULT_PROFILE_NAME, new Profile(this.selectedProfile));
            }
        }
        return this.profiles.get(this.selectedProfile);
    }

    public Map<String, Profile> getProfiles() {
        return this.profiles;
    }

    public void addRefreshedProfilesListener(RefreshedProfilesListener listener) {
        this.refreshedProfilesListeners.add(listener);
    }

    public void setSelectedProfile(String selectedProfile) {
        boolean update = !this.selectedProfile.equals(selectedProfile);
        this.selectedProfile = selectedProfile;
        if (update) {
            this.fireRefreshEvent();
        }
    }

    public AuthenticationDatabase getAuthDatabase() {
        return this.authDatabase;
    }

    public void trimAuthDatabase() {
        HashSet<String> uuids = new HashSet<String>(this.authDatabase.getknownUUIDs());
        for (Profile profile : this.profiles.values()) {
            uuids.remove(profile.getPlayerUUID());
        }
        for (String uuid : uuids) {
            this.authDatabase.removeUUID(uuid);
        }
    }

    private static class RawProfileList {
        public Map<String, Profile> profiles = new HashMap<String, Profile>();
        public String selectedProfile;
        public UUID clientToken = UUID.randomUUID();
        public AuthenticationDatabase authenticationDatabase;

        private RawProfileList(Map<String, Profile> profiles, String selectedProfile, UUID clientToken, AuthenticationDatabase authenticationDatabase) {
            this.profiles = profiles;
            this.selectedProfile = selectedProfile;
            this.clientToken = clientToken;
            this.authenticationDatabase = authenticationDatabase;
        }

        public static class Serializer
        implements JsonSerializer<RawProfileList>,
        JsonDeserializer<RawProfileList> {
            private final Launcher launcher;

            public Serializer(Launcher launcher) {
                this.launcher = launcher;
            }

            @Override
            public RawProfileList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = (JsonObject)json;
                Map profiles = Maps.newHashMap();
                if (object.has("profiles")) {
                    profiles = (Map)context.deserialize(object.get("profiles"), new TypeToken<Map<String, Profile>>(){}.getType());
                }
                String selectedProfile = null;
                if (object.has("selectedProfile")) {
                    selectedProfile = object.getAsJsonPrimitive("selectedProfile").getAsString();
                }
                UUID clientToken = UUID.randomUUID();
                if (object.has("clientToken")) {
                    clientToken = (UUID)context.deserialize(object.get("clientToken"), (Type)((Object)UUID.class));
                }
                AuthenticationDatabase database = new AuthenticationDatabase(new YggdrasilAuthenticationService(this.launcher.getProxy(), this.launcher.getClientToken().toString()));
                if (object.has("authenticationDatabase")) {
                    database = (AuthenticationDatabase)context.deserialize(object.get("authenticationDatabase"), (Type)((Object)AuthenticationDatabase.class));
                }
                return new RawProfileList(profiles, selectedProfile, clientToken, database);
            }

            @Override
            public JsonElement serialize(RawProfileList src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject object = new JsonObject();
                object.add("profiles", context.serialize(src.profiles));
                object.add("selectedProfile", context.serialize(src.selectedProfile));
                object.add("clientToken", context.serialize(src.clientToken));
                object.add("authenticationDatabase", context.serialize(src.authenticationDatabase));
                return object;
            }
        }
    }
}

