/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher;

import com.mojang.authlib.Agent;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.launcher.UserInterface;
import com.mojang.launcher.game.runner.GameRunner;
import com.mojang.launcher.profile.Profile;
import com.mojang.launcher.profile.ProfileManager;
import com.mojang.launcher.updater.ExceptionalThreadPoolExecutor;
import com.mojang.launcher.updater.VersionManager;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Launcher {
    private static final Logger LOGGER;
    private final VersionManager versionManager;
    private final GameRunner gameRunner;
    private final File workingDirectory;
    private final UserInterface ui;
    private final Proxy proxy;
    private final PasswordAuthentication proxyAuth;
    private final ProfileManager profileManager;
    private final ThreadPoolExecutor downloaderExecutorService = new ExceptionalThreadPoolExecutor(16, 16, 30L, TimeUnit.SECONDS);
    private final Agent agent;
    private UUID clientToken = UUID.randomUUID();

    public Launcher(UserInterface ui, File workingDirectory, Proxy proxy, PasswordAuthentication proxyAuth, VersionManager versionManager, Agent agent, GameRunner gameRunner) {
        this.ui = ui;
        this.proxy = proxy;
        this.proxyAuth = proxyAuth;
        this.workingDirectory = workingDirectory;
        this.agent = agent;
        this.gameRunner = gameRunner;
        this.profileManager = new ProfileManager(this);
        this.versionManager = versionManager;
        this.downloaderExecutorService.allowCoreThreadTimeOut(true);
        this.refreshVersionsAndProfiles();
    }

    public void refreshVersionsAndProfiles() {
        this.versionManager.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher.this.versionManager.refreshVersions();
                }
                catch (Throwable e) {
                    LOGGER.error("Unexpected exception refreshing version list", e);
                }
                try {
                    Launcher.this.profileManager.loadProfiles();
                    LOGGER.info("Loaded " + Launcher.this.profileManager.getProfiles().size() + " profile(s); selected '" + Launcher.this.profileManager.getSelectedProfile().getName() + "'");
                }
                catch (Throwable e) {
                    LOGGER.error("Unexpected exception refreshing profile list", e);
                }
                Launcher.this.ensureLoggedIn();
            }
        });
    }

    public void ensureLoggedIn() {
        Profile selectedProfile = this.profileManager.getSelectedProfile();
        UserAuthentication auth = this.profileManager.getAuthDatabase().getByUUID(selectedProfile.getPlayerUUID());
        if (auth == null) {
            this.ui.showLoginPrompt();
        } else if (!auth.isLoggedIn()) {
            if (auth.canLogIn()) {
                try {
                    auth.logIn();
                    try {
                        this.profileManager.saveProfiles();
                    }
                    catch (IOException e) {
                        LOGGER.error("Couldn't save profiles after refreshing auth!", (Throwable)e);
                    }
                    this.profileManager.fireRefreshEvent();
                }
                catch (AuthenticationException e) {
                    LOGGER.error("Exception whilst logging into profile", (Throwable)e);
                    this.ui.showLoginPrompt();
                }
            } else {
                this.ui.showLoginPrompt();
            }
        } else if (!auth.canPlayOnline()) {
            try {
                LOGGER.info("Refreshing auth...");
                auth.logIn();
                try {
                    this.profileManager.saveProfiles();
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save profiles after refreshing auth!", (Throwable)e);
                }
                this.profileManager.fireRefreshEvent();
            }
            catch (InvalidCredentialsException e) {
                LOGGER.error("Exception whilst logging into profile", (Throwable)e);
                this.ui.showLoginPrompt();
            }
            catch (AuthenticationException e) {
                LOGGER.error("Exception whilst logging into profile", (Throwable)e);
            }
        }
    }

    public UUID getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(UUID clientToken) {
        this.clientToken = clientToken;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public GameRunner getGameRunner() {
        return this.gameRunner;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public UserInterface getUserInterface() {
        return this.ui;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public PasswordAuthentication getProxyAuth() {
        return this.proxyAuth;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public ThreadPoolExecutor getDownloaderExecutorService() {
        return this.downloaderExecutorService;
    }

    public void shutdownLauncher() {
        this.getUserInterface().shutdownLauncher();
    }

    public Agent getAgent() {
        return this.agent;
    }

    static {
        Thread.currentThread().setContextClassLoader(Launcher.class.getClassLoader());
        LOGGER = LogManager.getLogger();
    }
}

