/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_c.rb
*/

#include <stdlib.h>
#include <stdbool.h>

/*!
** Taille du terrain (longueur et largeur).
*/
# define TAILLE_TERRAIN            30

/*!
** Nombre de tours à jouer avant la fin de la partie.
*/
# define NB_TOURS                  100

/*!
** Nombre de points de déplacement par tour (avant utilisation du turbo).
*/
# define NB_POINTS_DEPLACEMENT     6

/*!
** Nombre de points d'action par tour.
*/
# define NB_POINTS_ACTION          42

/*!
** Nombre de points d'action que coûte la capture d'un portail.
*/
# define COUT_CAPTURE              3

/*!
** Nombre de points d'action que coûte la création d'un lien.
*/
# define COUT_LIEN                 2

/*!
** Nombre de points d'action que coûte la neutralisation d'un portail de base.
*/
# define COUT_NEUTRALISATION       10

/*!
** Nombre de points d'action supplémentaires que coûte la neutralisation pour chaque bouclier présent.
*/
# define COUT_NEUTRALISATION_BOUCLIER 5

/*!
** Nombre de points d'action que coûte la mise en place d'un bouclier sur un portail sans bouclier.
*/
# define COUT_BOUCLIER             3

/*!
** Nombre de points d'action que coûte l'utilisation d'un turbo.
*/
# define COUT_TURBO                6

/*!
** Nombre maximum de boucliers sur un même portail.
*/
# define MAX_BOUCLIERS             6

/*!
** Nombre de points que rapporte la capture d'un portail.
*/
# define POINTS_CAPTURE            10

/*!
** Constante de proportionnalité reliant l'aire d'un champ au nombre de points qu'il rapporte par tour.
*/
# define POINTS_CHAMP              2

/*!
** Erreurs possibles
*/
typedef enum erreur {
  OK, /* <- L'action a été exécutée avec succès */
  PA_INSUFFISANTS, /* <- Vous ne possédez pas assez de points d'action pour cette action. */
  AUCUN_PORTAIL, /* <- La position spécifiée n'est pas un portail. */
  POSITION_INVALIDE, /* <- La position spécifiée est hors de la carte. */
  POSITION_ELOIGNEE, /* <- La destination est trop éloignée. */
  PORTAIL_AMI, /* <- Le portail vous appartient. */
  PORTAIL_NEUTRE, /* <- Le portail est neutre. */
  PORTAIL_ENNEMI, /* <- Le portail appartient à votre adversaire. */
  LIEN_INTERSECTION, /* <- Le lien croise un lien existant. */
  LIEN_CHAMP, /* <- Le lien se trouve dans un champ existant. */
  LIEN_DEGENERE, /* <- Les deux extrémités du lien coïncident. */
  LIMITE_BOUCLIERS, /* <- Ce portail est équipé du nombre maximal de boucliers. */
} erreur;


struct position;
struct lien;
struct champ;

typedef struct lien_array {
  struct lien* datas;
  size_t length;
} lien_array;

typedef struct champ_array {
  struct champ* datas;
  size_t length;
} champ_array;

typedef struct position_array {
  struct position* datas;
  size_t length;
} position_array;

/*!
** Position sur la carte, donnée par deux coordonnées.
*/
typedef struct position {
  int x;  /* <- Coordonnée en X */
  int y;  /* <- Coordonnée en Y */
} position;


/*!
** Représente un lien existant.
*/
typedef struct lien {
  position extr1;  /* <- Première extrémité du lien. */
  position extr2;  /* <- Seconde extrémité du lien. */
  int joueur_l;  /* <- Joueur possédant ce lien. */
} lien;


/*!
** Représente un champ de contrôle existant.
*/
typedef struct champ {
  position som1;  /* <- Premier sommet du champ. */
  position som2;  /* <- Deuxième sommet du champ. */
  position som3;  /* <- Troisième sommet du champ. */
  int joueur_c;  /* <- Joueur possédant ce champ. */
} champ;


/*!
** Déplace votre agent sur la case passée en argument.
*/
erreur deplacer(position dest);

/*!
** Utilise un turbo.
*/
erreur utiliser_turbo(void);

/*!
** Capture le portail où est positionné votre agent.
*/
erreur capturer(void);

/*!
** Crée un lien entre le portail où se trouve votre agent et le portail de destination donné en argument.
*/
erreur lier(position portail);

/*!
** Neutralise le portail où se trouve votre agent.
*/
erreur neutraliser(void);

/*!
** Ajoute un bouclier au portail sur lequel se trouve votre agent.
*/
erreur ajouter_bouclier(void);

/*!
** Renvoie la liste de tous les liens présents.
*/
lien_array liste_liens(void);

/*!
** Renvoie la liste de tous les champs de contrôle.
*/
champ_array liste_champs(void);

/*!
** Renvoie la liste de tous les portails de la carte.
*/
position_array liste_portails(void);

/*!
** Renvoie la liste de tous les liens existants qui croisent un segment, entravant la création d'un lien.
*/
lien_array liens_bloquants(position ext1, position ext2);

/*!
** Prend les positions de deux portails, et renvoie un booléen indiquant s'ils sont reliés. Le résultat est `false` lorsque l'une des deux positions ne repère pas un portail.
*/
bool lien_existe(position ext1, position ext2);

/*!
** Renvoie un booléen indiquant si les 3 positions repèrent bien 3 portails tous reliés entre eux.
*/
bool champ_existe(position som1, position som2, position som3);

/*!
** Renvoie un booléen indiquant si la case ``pos`` se trouve dans un champ.
*/
bool case_dans_champ(position pos);

/*!
** Renvoie la liste des champs à l'intérieur desquels ``pos`` se trouve. Si la case est un portail, le résultat de ``case_champs`` sera disjoint de celui de ``champs_incidents_portail``.
*/
champ_array case_champs(position pos);

/*!
** Renvoie le numéro du joueur correspondant au portail donné, -1 si le portail est neutre, -2 si la case n'est pas un portail. Vous pouvez utiliser cette fonction pour vérifier qu'une case donnée est bien un portail.
*/
int portail_joueur(position portail);

/*!
** Renvoie le nombre de boucliers présents sur un portail (-2 si la case n'est pas un portail).
*/
int portail_boucliers(position portail);

/*!
** Renvoie la liste de tous les liens dont le portail donné est une extrémité.
*/
lien_array liens_incidents_portail(position portail);

/*!
** Renvoie la liste de tous les champs dont le portail donné est un sommet.
*/
champ_array champs_incidents_portail(position portail);

/*!
** Renvoie la liste de tous les champs dont le lien donné est un côté. Si le segment n'est pas un lien présent, renvoie la liste de tous les champs que la création du lien ferait apparaître.
*/
champ_array champs_incidents_segment(position ext1, position ext2);

/*!
** Renvoie la liste des portails capturés par votre adversaire au dernier tour.
*/
position_array hist_portails_captures(void);

/*!
** Renvoie la liste des portails neutralisés par votre adversaire au dernier tour.
*/
position_array hist_portails_neutralises(void);

/*!
** Renvoie la liste des liens créés par votre adversaire au dernier tour.
*/
lien_array hist_liens_crees(void);

/*!
** Renvoie la liste des champs créés par votre adversaire au dernier tour.
*/
champ_array hist_champs_crees(void);

/*!
** Renvoie la liste des positions où votre adversaire a ajouté des boucliers au dernier tour.
*/
position_array hist_boucliers_ajoutes(void);

/*!
** Renvoie la distance de Manhattan entre deux positions.
*/
int distance(position pos1, position pos2);

/*!
** Renvoie le nombre de points que rapporte(rait) chaque tour un champ existant ou hypothétique.
*/
int score_triangle(position som1, position som2, position som3);

/*!
** Indique si deux segments se croisent. Cette fonction correspond exactement à la condition d'interférence entre liens, c'est-à-dire qu'elle renvoie ``false`` si l'intersection est une extrémité des deux segments.
*/
bool intersection_segments(position a1, position a2, position b1, position b2);

/*!
** Indique si un point se trouve à l'intérieur d'un triangle. Le critère coïncide avec celui de ``case_champs``.
*/
bool point_dans_triangle(position p, position som1, position som2, position som3);

/*!
** Renvoie votre numéro de joueur.
*/
int moi(void);

/*!
** Renvoie le numéro de votre adversaire.
*/
int adversaire(void);

/*!
** Indique la position de l'agent du joueur désigné par le numéro ``id_joueur``.
*/
position position_agent(int id_joueur);

/*!
** Indique votre nombre de points d'actions restants pour ce tour-ci.
*/
int points_action(void);

/*!
** Indique votre nombre de points de déplacement restants pour ce tour-ci.
*/
int points_deplacement(void);

/*!
** Renvoie le score du joueur désigné par le numéro ``id_joueur``.
*/
int score(int id_joueur);

/*!
** Renvoie le numéro du tour actuel.
*/
int tour_actuel(void);

/*!
** Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
*/
bool annuler(void);

/*!
** Affiche le contenu d'une valeur de type erreur
*/
void afficher_erreur(erreur v);

/*!
** Affiche le contenu d'une valeur de type position
*/
void afficher_position(position v);

/*!
** Affiche le contenu d'une valeur de type lien
*/
void afficher_lien(lien v);

/*!
** Affiche le contenu d'une valeur de type champ
*/
void afficher_champ(champ v);

/*!
** Fonction appelée au début de la partie.
*/
void partie_init(void);

/*!
** Fonction appelée à chaque tour.
*/
void jouer_tour(void);

/*!
** Fonction appelée à la fin de la partie.
*/
void partie_fin(void);

